#ifndef _ALLOCATOR_H
#define _ALLOCATOR_H

#include "common/oref.h"
#include "common/orefs.h"

class OR_obj;

class Allocator {
    // Allocates OR_objs of a given size and class.
public:
    Allocator(Oref class_oref, int size);
    // For objects with given "class_oref" and of "size" slots.

    OR_obj *mod(Oref oref);
    // Returns a new obj to replace object given by "oref".
    // Also registers copy as a modified obj with gc->transaction.

    OR_obj *copy(OR_obj *obj, Oref oref);
    // Like "mod()", except also copies obj into that returned.

    void free(Oref oref);
    // Registers oref as available for reuse.

    OR_obj* alloc(Oref &oref);
    // Returns a new obj and sets "oref" to an unused oref.
    // First uses orefs that were freed recently (in LIFO order).

private:
    
    Orefs free_orefs;

    Oref const class_oref;
    int const size;
    unsigned objs_per_page; // Max number of objs that fit in a page.

    // The following data structures track orefs available for allocation. 
    // XXX They should be persistent to avoid leaks on crashes.
    unsigned free_seg; // segment to allocate new orefs from
    unsigned free_page; // next page within free_seg to allocate from
    unsigned free_onum; // next onum within free_page to allocate from

};

#endif /* _ALLOCATOR_H */
