#ifndef _CLASS_MAP_H
#define _CLASS_MAP_H

// A Class_map maps class orefs to information such as size and bitfields.

#include "utils/array.h"
#include "common/oref.h"
#include "common/obj_bitfield.h"

struct Class_info {
    int size;
    Obj_bitfield ref_bits;
    char *name;
    bool variable_size;
};

declareArray(Class_infos, Class_info)
class Class_map: public Class_infos {
public:
    Class_map();

    bool find(Oref class_oref, Class_info& class_info) {
	// Sets "class_info" to that for "class_oref". Returns whether found. 
	if (class_oref < (unsigned) size()) {
	    class_info = slot(class_oref);
	    return (class_info.size >= 0);
	}
	return FALSE;
    }
    void store(char * name, Oref class_oref, int objsize, Obj_bitfield ref_bits) {
	// Store "class_info" for "class_oref".
	if (class_oref >= (unsigned) size()) {
	    Class_info invalid = {-1, 0};
	    append(invalid, class_oref-size()+1);
	}
	Class_info class_info = {objsize, ref_bits};
        class_info.name = new char[strlen(name) + 1];
        class_info.variable_size = (objsize == -1) ? TRUE : FALSE;
        strcpy(class_info.name, name);
	slot(class_oref) = class_info;
    }
};

#endif /* _CLASS_MAP_H */
