#include "common/modset.h"
#include "common/transaction.h"
#include "or/or.h"
#include "or/tm.h"

#include "gc_transaction.h"
#include "gc.h"
#include "collector.h"
#include "class_map.h"

implementArray(Obj_orefs, Obj_oref)

GC_transaction::GC_transaction() {
    mos = new Modset;
}

GC_transaction::~GC_transaction() {
    delete mos;
}

void GC_transaction::new_obj(Oref oref, OR_obj *obj) {
    Obj_oref oo = {obj, oref};
    new_objs.append(oo);
    printf("GC_transaction::new_obj, oref=%d, class_oref=%d\n",
	   oref, obj->class_oref()); //DEBUG
}

void GC_transaction::mod_obj(Oref oref, OR_obj *obj) {
    printf("GC_transaction::mod_obj, oref=%d, class_oref=%d\n",
	   oref, obj->class_oref()); //DEBUG
    // First check if oref already exists in the mod_objs.
    for (int i = 0; i < mod_objs.size(); i++) {
	Obj_oref oo = mod_objs[i];
	if (oref == oo.oref) {
	    delete [] oo.obj;
	    oo.obj = obj;
	    return;
	}
    }
    Obj_oref oo = {obj, oref};
    mod_objs.append(oo);
}

static int get_size(Oref class_oref) {
    // Gets size of objects with given class.
    // Fails if information is not found.
    Class_info class_info;
    bool found = gc->class_map->find(class_oref, class_info);
    if (!found) 
	fail("ERROR: GC_transaction::get_size: no info for %s, class oref=%d", 
	     class_info.name,
	     class_oref);
    return class_info.size;
}

void GC_transaction::mod_obj_now(Oref oref, OR_obj *obj) {
    Oref class_oref = obj->class_oref();
    int size = get_size(class_oref);
    mos->add_object(oref, obj, size, class_oref);
}

void GC_transaction::commit() {
    printf(">>> GC_transaction::commit\n"); //DEBUG
    if (new_objs.size()==0 && mod_objs.size()==0 && mos==0) return;
    st.commits++;
    st.commit_timer.start();
    Transaction transaction;
    transaction.mos = mos;
    transaction.nos = new Modset();
    transaction.ros = NULL;
    for (int i = 0; i < mod_objs.size(); i++) {
	Obj_oref oo = mod_objs[i];
	Oref class_oref = oo.obj->class_oref();
	int size = get_size(class_oref);
	transaction.mos->add_object(oo.oref, oo.obj, size, class_oref);
	delete [] oo.obj;
    }
    mod_objs.clear();
    for (int i = 0; i < new_objs.size(); i++) {
	Obj_oref oo = new_objs[i];
	Oref class_oref = oo.obj->class_oref();
	int size = get_size(class_oref);
	transaction.nos->add_object(oo.oref, oo.obj, size, class_oref);
	gc->collector->new_gc_object(oo.oref);
	delete [] oo.obj;
    }
    new_objs.clear();
    orx->tm->commit_exclusive(&transaction); // deletes mos and nos
    mos = new Modset(); 
    st.commit_timer.stop();
}

GC_transaction::Stats::Stats() {
    on = FALSE;
}

void GC_transaction::Stats::start() {
    on = TRUE;
    commits = 0;
}

void GC_transaction::Stats::print(ostream *out) {
    *out << "Time to commit: " << commit_timer.elapsed() << endl;
    *out << "Number of commits: " << commits << endl;
}
