#ifndef _GC_TRANSACTION_H
#define _GC_TRANSACTION_H

#include <iostream.h>

#include "utils/array.h"
#include "utils/Timer.h"
#include "common/oref.h"

class OR_obj;
class Modset;

struct Obj_oref {
    OR_obj *obj;
    Oref oref;
};

declareArray(Obj_orefs, Obj_oref)

class GC_transaction {
    // Tracks new and modified objects due to GC to be commited later.
public:
    GC_transaction();
    ~GC_transaction();

    void new_obj(Oref oref, OR_obj *obj);
    // The state of "obj" at next commit is added as a new object.

    void mod_obj(Oref oref, OR_obj *obj);
    // The state of "obj" at next commit is added as a modified object.
    // If a modification was previously added for "oref", 
    // "obj" will overwrite the previous modification.

    void mod_obj_now(Oref oref, OR_obj *obj);
    // The current state of "obj" is added as a modified object.
    // This is useful to copy objects modified within the cache, 
    // which may disappear before the commit time.

    void commit();
    // Commit transaction with new and modified objects added earlier.

    // Statistics
    class Stats {
    public:
        Stats();
	int commits; // number of commits
	Timer commit_timer; // time taken to commit
	void print(ostream *out); // print it on out
	void start(); // start collecting stats
	bool on; // whether collecting stats
    } st;

private:
    Obj_orefs mod_objs; // modified objs in the current transaction
    Obj_orefs new_objs;      // new objs in the current transaction
    Modset *mos;             // modified obj states
};

#endif /* _GC_TRANSACTION_H */
