#include "scanlist.h"
#include "deltalists.h"
#include "gc.h"
#include "partition.h"

Scanlist::Scanlist():
    markmap(gc->segments_per_partition * Max_pages_in_seg * Max_objs_in_page,
	    FALSE)
{}

void Scanlist::clear() {
    orefs.clear();
    markmap.clear();
}

void Scanlist::enter(Oref oref) {
    enter_ranked(oref, gc->partition_map->oref_to_orank(oref));
}

Oref Scanlist::remove() {
    if (0 == orefs.size()) return NULL_OREF;
    return orefs.remove();
}
