#ifndef _SCANLIST_H
#define _SCANLIST_H

#include "utils/bool_vector.h"
#include "common/orefs.h"

// Data structures to hold orefs of objs to be scanned.

class Collector;

class Scanlist {
public:
    Scanlist();

    void clear();
    // Empties the scanlist.

    void enter(Oref oref);
    // If "oref" is not already marked, marks it 
    // and puts it in a list to scan.

    void enter_ranked(Oref oref, Uint obj_rank);
    // Like enter, but receives a precomputed obj_rank (hence faster).

    Oref remove();
    // Removes and returns an oref from scanlist.

    void set_collectable(Oref oref, bool collectable);
    // sets the variable-size attribute for an obj_rank

private:
    Orefs orefs; // objects to scan
    Bool_vector markmap;
    friend Collector;
};

inline void Scanlist::enter_ranked(Oref oref, Uint orank) {
    if (markmap.test(orank)) return;
    markmap.set(orank);
    orefs.append(oref);
}

#endif /* _SCANLIST_H */
