#ifndef _TEST_SCAN_MODS_H
#define _TEST_SCAN_MODS_H

#include "common/orefs.h"
class Itable_Mods;
class Random;

class Test_scan_mods {
public:
    Test_scan_mods();

    void create_db();
    // Creates the db.

private:

    Itable_Mods *mods;
    // Local copy of mods so that they can be unref'ed.

    int obj_slots; // number of slots in objs created
    unsigned int num_segments;
    unsigned int start_segment;
    unsigned int objects_in_page;
    bool gather_or_stats;     
    int create_segments_randomly;     
    unsigned int reference_range;
    Random *random; // generates random numbers

    void create_segment(Uint segid);
    void create_page(Uint pageid);
    // Requires: given segment/page is empty and we have allocation rights.
    // Populates given segment/page with objects.

    void create_object(Oref oref);
    // Creates a new Link object with given oref and initializes it as follows:
    // Sets field[0] to the index of the object, generated sequentially.
    // Sets field[1] to another oref generated by "create_link".      

    Oref create_link(Oref from);
    // Returns an oref for storing in an object with oref "from".

    Oref oindex_to_oref(Uint oindex);
    // Converts object index to oref.

    Uint oref_to_oindex(Oref oref);
    // Converts oref to index.
};

#endif /* _TEST_SCAN_MODS_H */
