#ifndef _TRANSLISTS_H
#define _TRANSLISTS_H

#include <iostream.h>
#include "utils/array.h"
#include "utils/Timer.h"
#include "common/oref.h"
#include "common/orefs.h"

class OR_obj;
union OR_slot;
class Modset;
class MM_HandleList;
class MM_Handle;
class Allocator;

class Deltalist;

class Translists {
// A Translist stores the set of references from a source partition to a
// target partition.
public:
    Translists();

    int merge_delta(Uint source_p, Uint target_p, 
		    Deltalist *delta, bool replace);
    // Merges "delta" into the translist from source_p to target_p.
    // If "replace", empties translist first, but maintains
    // the oref of the first block.
    // If the translist is created or emptied as a result, updates
    // gc->inoutlists.
    // Puts modified and new translist blocks in gc->transaction.
    // Returns the size difference of the translist from before the 
    // call to after the merge_delta call.

    class Elements {
    public:
	Elements(Oref translist_oref);
	// Will generate orefs in translist stored at translist_oref.

	Oref get();
	// Returns the next oref in the translist; NULL_OREF when none.

	void release();
	// Must be called at end if terminating before get returns NULL_OREF.
    private:
	int i; // slot in fields to consider next	
	MM_Handle *handle;
	OR_slot *fields;
    };

    // Statistics
    class Stats {
    public:
        Stats();
	int num_translists;
	int blocks; // number of blocks allocated
	int fetches; // number of block fetches
	int mob_fetches; // fetches served from mob
	int disk_fetches; // fetches served from disk
	void print(ostream *out); // print it on out
	void start(); // start collecting stats
    } st;

private:
    Allocator *allocator; // To allocate translistblocks

    void free_translist(Oref translist_oref);
    // Deallocates block orefs in the specified translist
    // and makes them available for reuse throught the allocator
    // in FIFO order.

};

#endif /* _TRANSLISTS_H */
