# Copyright 1995 Barbara Liskov

# Support for building multi-user OO7 databases.
#
# Read "A Status Report on the OO7 OODBMS Benchmarking Effort" by
# Carey, DeWitt, Kant, and Naughton.  OOPSLA' 94.

# Get support code from original OO7 stuff.
source init/oo7.tcl
source init/real_oo7.tcl

# Parameters for Multi-user OO7
set NumSharCompPerClient 200

# effects	Create a multi-user database for "n" clients.
#		This will have "n" private modules, plus one
#		shared module.  These modules will be referenced
#		from a vector.  The "0..n-1" entries will be
#		the private modules.  The "n"th entry will be
#		the shared module.

proc make_multi_db {n} {
    # Create "n" private modules
    set modules {}
    for {set i 0} {$i < $n} {incr i} {
	lappend modules [CreateOO7Database]
	puts stderr "made private module $i"
    }

    # Create a shared module.  This will have "n" sub-modules.

    # Temporarily change the parameters for the shared module
    global Root_NumAssmPerAssm NumCompPerModule NumSharCompPerClient
    set saveRoot $Root_NumAssmPerAssm
    set saveComp $NumCompPerModule
    set Root_NumAssmPerAssm $n
    set NumCompPerModule [expr $n * $NumSharCompPerClient]

    # Make the shared module
    lappend modules [CreateOO7Database]

    # Restore parameters
    set Root_NumAssmPerAssm $saveRoot
    set NumCompPerModule $saveComp

    puts stderr "made shared module for $n"

    return [tcl_list_to_thor_vec $modules]
}
