# Copyright 1995 Barbara Liskov

source init/or.tcl

# This is used in generating oo7objects and has nothing to do with
# the oids used internally in Thor.
set object_id 0

# effects - conventional creation of an atomic object.  Almost never used
#           because you don't usually know all this information before
#           allocating a bunch of objects.

proc oo7object {seg id x y date to_list from_list parent} {
  return [thorlist $seg $id $x $y $date $to_list $from_list $parent]
}

# effects - allocate storage for an atomic object.  Return its 
#           oref and the orefs for the yet-to-be-computed to_list,
#           from_list, and parent object.

proc oo7obj_start {seg id x y date} { 
  set parent [new $seg fulllist {allrefs 2}]
  set from_list [new $seg fulllist {allrefs 2}]
  set to_list [new $seg fulllist {allrefs 2}]
  store $parent 1 [thornil $seg]
  store $from_list 1 $parent
  store $to_list 1 $from_list
  set result [thorcons $seg [intcell $seg $id] \
               [thorcons $seg [intcell $seg $x] \
	         [thorcons $seg [intcell $seg $y] \
		   [thorcons $seg [intcell $seg $date] \
		     $to_list]]]]
  return [list $result $to_list $from_list $parent]
}


# accessors for data structure returned above
proc oo7_ds_obj    {ds} { return [lindex $ds 0] }
proc oo7_ds_to     {ds} { return [lindex $ds 1] }
proc oo7_ds_from   {ds} { return [lindex $ds 2] }
proc oo7_ds_parent {ds} { return [lindex $ds 3] }

# effects - allocate the "next" object, by incrementing a global counter
#           and using that value for all non-pointer fields.

proc oo7nextobj {seg} {
  global object_id
  set val $object_id
  set result [oo7obj_start $seg $val $val $val $val]
  incr object_id
  return $result
}

# effects - allocate a new composite object containing "atoms" atomic 
#           objects, each with "conns" references to each other
#           (randomly chosen)
# XXX need more data fields -- this is only a placeholder for the atomics

proc oo7composite {seg conns atoms} {
  global object_id
  set self [new $seg fulllist {allrefs 2}]
  store $self 0 [intcell $seg $object_id]
  incr object_id
  set contents [new $seg fulllist {allrefs 2}]
  store $self 1 $contents
  connmap to_list from_list $conns $atoms
  for {set i 0} {$i < $atoms} {incr i} {
    set atomics($i) [oo7nextobj $seg]
  }
  for {set i 0} {$i < $atoms} {incr i} {
    oo7build_to_list $seg $atomics($i) atomics $to_list($i)
    oo7build_from_list $seg $atomics($i) atomics $from_list($i)
    store [oo7_ds_parent $atomics($i)] 0 $self
  }
  set objroot [rand $atoms]
  store $contents 0 [oo7_ds_obj $atomics($objroot)]
  store $contents 1 [thornil $seg]
  return $self
}

proc oo7build_to_list {seg dest atomics_ to_list} {
  upvar $atomics_ atomics
  oo7fill_in_list $seg [oo7_ds_to $dest] $to_list atomics
}

proc oo7build_from_list {seg dest atomics_ from_list} {
  upvar $atomics_ atomics
  oo7fill_in_list $seg [oo7_ds_from $dest] $from_list atomics
}

# effects - construct a Thor list from the tcl list of indexes into
#           the array of orefs of atomic objects, put it into
#           slot 0 of ds.

proc oo7fill_in_list {seg ds index_list atomics_} {
  upvar $atomics_ atomics
  set len [llength $index_list]
  set current [thornil $seg]
  for {set i 0} {$i < $len} {incr i} {
    set next [new $seg fulllist {allrefs 2}]
    store $next 0 [oo7_ds_obj $atomics([lindex $index_list $i])]
    store $next 1 $current
    set current $next
  }
  store $ds 0 $current
}

# effects - sets to_ and from_ to be arrays of lists.  The indices
#           of to_ go from 0 to $objs-1, and each list is $conns long.
#           Each element of each list is a random number x such that 
#	    0 <= x <= $objs-1.
#           _from($q) contains $z iff _to($z) contains $q

proc connmap {to_ from_ conns objs} {
  upvar $to_ to
  upvar $from_ from
  for {set i 0} {$i < $objs} {incr i} {
    set to($i) {}
    set from($i) {}
  }
  for {set i 0} {$i < $objs} {incr i} {
    for {set j 0} {$j < $conns} {incr j} {
      set conn [rand $objs]
      set to($i) [concat $to($i) $conn]
      set from($conn) [concat $from($conn) $i]
    }
  }
}


