// Copyright 1995 Barbara Liskov

/*
   \section{Invalid object set implmentation}
 */

#include "utils/th_assert.h"
#include "utils/openhashmap.h"
#include "common/oref.h"
#include "common/orefs.h"
#include "common/oref_set.h"
#include "inv_set.h"

implementOpenHashMap(Inv_set, Oref, Collection_num, Oref_hash, Oref_equal)

/////////////////////////////// Public functions

Invalid_set::Invalid_set(void)
{
    highest_collection_num = 0;
    invalid_set = new Inv_set;
}
    
Invalid_set::~Invalid_set(void)
{
    delete invalid_set;
}    

bool Invalid_set::member(Oref x)
{
    return invalid_set->contains(x);
}

bool Invalid_set::empty() {
    return (invalid_set->size() == 0);
}

void Invalid_set::add_obj(Oref x, Collection_num n)
{
    Collection_num old_num;

    assert(n <= highest_collection_num);

    if (invalid_set->fetch(x, old_num))
	invalid_set->store(x, (n > old_num) ? n : old_num);
    else invalid_set->store(x, n);
}
    
Orefs *Invalid_set::invalidated_since(Collection_num n) {
    Inv_set::Bindings bindings(invalid_set);
    Orefs *set = new Orefs;

    for (; bindings.ok(); bindings.next() )
	if (bindings.val() > n)
	    set->append(bindings.key());

    return set;
}
    
void Invalid_set::remove_before(Collection_num n)
{
    Inv_set::Bindings bindings(invalid_set);
    Orefs *remove_orefs = new Orefs;  
    int size;

    // Can't modify invalid set in generator, so need to build up 
    // temporary set of orefs to delete.
    // Can use array since object appears at most once.
    for (; bindings.ok(); bindings.next() )
	if (bindings.val() <= n)
	    remove_orefs->append(bindings.key());

    size = remove_orefs->size();
    for (int i = 0; i < size; i++)
	invalid_set->remove(remove_orefs->slot(i));
    
    delete remove_orefs;
}

Collection_num Invalid_set::new_collection(void)
{
    return ++highest_collection_num;
}
    
void Invalid_set::reset(void)
{
    invalid_set->clear();
    highest_collection_num =0;
}

