#include <iostream.h>
#include "message_stats.h"
#include "common/fe_or_msg.h"

Message_Stats::Message_Stats() {
    reset();
}

void Message_Stats::reset() {
    fe_fetch = 0;
    fe_segment = fe_segment_bytes = 0;
    fe_fetch_denied = 0;
    fe_prepare_coord_bytes = 0;
    fe_dropped_segs = fe_dropped_segs_bytes = 0;

    or_fetch_ok = or_fetch_ok_bytes = 0;
    or_committed = or_committed_bytes = 0;
    or_abort = 0;
    or_invalidation = or_invalidation_bytes = 0;
    or_forwarded_fetch = or_forwarded_fetch_bytes = 0;

}

void Message_Stats::print() {
    cout << "FE->OR Messages (cummulative)" << endl;
    int size = sizeof(fe_message);
    cout << "Byte size of basic message = " << size << endl;
    cout << "fetch = " << fe_fetch 
	 << ", bytes = " << size*fe_fetch << endl;
    cout << "segment = " << fe_segment 
	 << ", bytes = " << size*fe_segment+fe_segment_bytes << endl;
    cout << "fetch_denied = " << fe_fetch_denied 
	 << ", bytes = " << size*fe_fetch_denied << endl;
    cout << "prepare_coord bytes = " << fe_prepares 
	 << ", bytes = " << size*fe_prepares+fe_prepare_coord_bytes << endl;
    cout << "dropped_segs = " << fe_dropped_segs 
	 << ", bytes = " << size*fe_dropped_segs+fe_dropped_segs_bytes << endl;

    cout << "OR->FE Messages (cummulative)" << endl;
    size = sizeof(or_message);
    cout << "Size of basic message = " << size << endl;
    cout << "fetch_ok = " << or_fetch_ok 
	 << ", bytes = " << size*or_fetch_ok+or_fetch_ok_bytes << endl;
    cout << "committed = " << or_committed
	 << ", bytes = " << size*or_committed+or_committed_bytes << endl;
    cout << "abort = " <<  or_abort 
	 << ", bytes = " << size*or_abort << endl;
    cout << "invalidation = " <<  or_invalidation
	 << ", bytes = " << size*or_invalidation+or_invalidation_bytes << endl;
    cout << "forwarded_fetch = " <<  or_forwarded_fetch
	 << ", bytes = " << size*or_forwarded_fetch+or_forwarded_fetch_bytes << endl;
}
