
#ifndef _AsynchIO_H
#define _AsynchIO_H

#include "utils/basic.h"
#include "or/thread.h"
#include "aiocb.h"

extern "C" {
int aio_read(aiocb_t *);
int aio_write(aiocb_t *);
int aio_error(aiocb_t *);
int aio_return(aiocb_t *);
int lio_listio(int mode, aiocb_t *list[], int nent, struct sigevent *sig);
int aio_cancel (int fildes, aiocb_t *ap);
}

#define MAX_AIO_THREADS 1

#define AIO_NO_SIGNAL 0
#define AIO_YES_SIGNAL 1
#define AIO_YES_BROADCAST 2

class AIO_Queue {
public:
  AIO_Queue ();
  ~AIO_Queue ();
  
  void              enqueue    (aio_completion_t *);
  aio_completion_t *dequeue    ();
  aio_completion_t *find_aiocb (const aiocb_t *);
  aio_completion_t *find_fd    (int);
  void              remove     (aio_completion_t *);
  int               size       ();

private:
  aio_result *head;
  aio_result *tail;
};

class AsynchIO;

class AsynchIO_daemon : public Thread {
public:
  void main           ();
  AsynchIO_daemon();
  AsynchIO_daemon(AsynchIO *, int);
private:
  AsynchIO *aio;
  int ID;
  void do_read();
  void do_write();
  void do_composite();
  void do_error();
  void queue_completed_request(int);
};



class AsynchIO {
  friend class AsynchIO_daemon;
public:
  // Create and destroy AsynchIO.  Also spawns/kills IO processing thread.
  AsynchIO();
  ~AsynchIO();
  AsynchIO(int);

  // IO routines
  int    read   (aiocb_t *);
  int    write  (aiocb_t *);
  size_t value (aiocb_t *); 
  int    error  (const aiocb_t *);
  int    listio (int mode, aiocb_t *list[], int nent, struct sigevent *sig);
  int    cancel (int fd, aiocb_t *);
private:
  void Init (AsynchIO *, int);            // Init routine for constructors
  void add_request_to_pending(aio_completion_t *, int);  // add completion_t to pending queue
  void init_completion_t(aio_completion_t *, aiocb_t *); // initialize completion_t with aiocb
  int partials_completed(aio_completion_t **, int); // are all of the partials done?
  int cancel_fd(int);                     // cancel requests for a file desc
  int cancel_aiocb(aiocb_t *);            // cancel request for an aiocb
  int threads;                            // number of IO threads
  AsynchIO_daemon **daemon;               // IO handling threads
  aio_completion_t **current;             // IO request being processed
  AIO_Queue *pending;                     // Pending IO requests
  AIO_Queue *completed;                   // Completed IO requests
  Mutex *mtx;                             // AIO mutex
  Condition *Message;                     // Cond for messages to thread
  int should_exit;                        // 0: no  1: yes
  Condition *Response;                    // Cond for responses from thread
  Condition *Finished;                    // Cond for thread cycle completion
  int exited;                             // Count of exited threads
  int errors;                             // Count of aiocb's unprocessable  
  int requests;                           // Total requests
};


#endif
