#ifndef _AIOCB_H
#define _AIOCB_H

#include "linux_sigevent.h"

/*
 * define the AIO/LIO constants
 */

// from sys/rt_limits.h
#define AIO_LISTIO_MAX 64
#define AIO_MAX 64
#define AIO_PRIO_DFL 5
#define AIO_PRIO_MAX 9
#define AIO_PRIO_MIN 0


// from sys/sysaio.h
#define AIO_CANCELED    0       /* all operations cancelled */
#define AIO_NOTCANCELED 1       /* not all operations cancelled */
#define AIO_ALLDONE     2       /* all operations were completed */

#define LIO_WAIT        1       /* wait for all operations to complete */
#define LIO_SUSPEND     2       /* wait for any to complete, no signal */
#define LIO_NOWAIT      3       /* don't wait for completion, signal */

#define LIO_READ        4
#define LIO_WRITE       5
#define LIO_GROUP       6       /* wait for group completion */
#define LIO_FDATASYNC   7       /* aio_fsync() with O_DSYNC */
#define LIO_FSYNC       8       /* aio_fsync() with O_SYNC */
#define AIO_KILL        9       /* kill AIO thread */
#define LIO_NOP         0
#define LIO_COMPOSITE   10      /* composite lio request */
// from errno.h
#define ECANCELED  94


typedef unsigned int aio_key_t; /* key/id for an aio */
typedef struct aiocb {
  int             aio_fildes;
  aio_key_t       aio_key;
  off_t           aio_offset;
  volatile void   *aio_buf;
  size_t          aio_nbytes;
  int             aio_reqprio;
  int             aio_lio_opcode;
  /* begin implementation extensions */
     struct aiocb    *aio_next;
     long            aio_reserved;
  /* end implementation extensions */
  int             signal;
  int             signo;
// #ifndef __linux__
  struct sigevent aio_sigevent;
// #endif
} aiocb_t;

typedef struct aio_result {
  struct aiocb          *aio_aiocb;
  ssize_t               aio_result;
  int                   aio_error;
  int                   completed; // 0:pending, 1:completed, -1:canceled
  struct aio_result     **partials;
  int                   num_partials;
  int                   reqID;
  struct aio_result     *next;
} aio_completion_t;



#endif
