#include <signal.h>

#include "utils/bits.h"
#include "utils/basic.h"
#include "utils/network.h"
#include "utils/Timer.h"
#include "common/locator.h"
#include "or/mm/logrecord.h"
#include "or/mm/log.h"
#include "or/mm/segtable.h"
#include "or/server.h"
#include "or/cachedir.h"

#include "or/mm/back_recv_message.h"
#include "or/mm/back_send_message.h"
#include "config/vdefs/REPLICATION.h"

#if REPLICATION

bool Back_recv_data_msg::decode(Network *net, Ubits32 msg_id) {

    Log_Record* log_rec;

    Ubits32 typeofrecord;
    int index_value;

    /* XXX rec is just a pointer. I use it to get
   value from the net and then append to the log
   */ 
    bool success = net->recv_ubits32(&noofrecords);
    if (!success) {
	perror("Data number mesg not received");
    }

    for (unsigned i = 0; i < noofrecords; i++) {

         if ( !net->recv_ubits32(&typeofrecord) ) {
	   perror("Data data mesg not received");
	 }
        switch (typeofrecord) {
	case Data_Log_Record_Type : log_rec = new Data_Log_Record(0); break;
        case Commit_Log_Record_Type : log_rec = new Commit_Log_Record(); break;
        case Abort_Log_Record_Type : log_rec = new Abort_Log_Record(); break;
        case Prepared_Log_Record_Type : log_rec = new Prepared_Log_Record(); break;
        case Committing_Log_Record_Type : log_rec = new Committing_Log_Record(); break;
        case Committed_Log_Record_Type : log_rec = new Committed_Log_Record(); break;
        case Done_Log_Record_Type : log_rec = new Done_Log_Record(); break;
        case Participant_Log_Record_Type : log_rec = new Participant_Log_Record(); break;
        case Stamos_Record_Type : log_rec = new Stamos_Record(); break;
        case Seg_Alloc_Record_Type : log_rec = new Seg_Alloc_Record(); break;
	}
        if ( !log_rec->decode(net) )  {
	   perror("Data data mersg not received");
	 }


	if (typeofrecord == Data_Log_Record_Type) {
	   ((Data_Log_Record*)log_rec)->commit();
	}

	if (typeofrecord == Seg_Alloc_Record_Type ) {
	  int segid =  orx->mm->alloc_new_segment();
	  Seg_bmap full_bmap(TRUE);
	  Seg_bmap bmap = orx->cachedir->enter(segid, full_bmap, orx->fe_manager,Page_complete, TRUE);

	}
	else {
	  index_value = orx->log->append(log_rec, FALSE);

	  log_rec->install();
	  orx->log->installed(index_value);
	}

    }

    Back_send_ack_msg ack_msg(noofrecords);
   
    if ( ! ( net->send_ubits32(msg_id, TRUE) && net->send_ubits32(ack_msg.type(), TRUE) && ack_msg.encode(net) ) ) {
       fail("error sending ack\n");
    }

    return TRUE;
}

Back_recv_shutdown_msg::Back_recv_shutdown_msg() {
 ;
}


bool Back_recv_shutdown_msg::decode(Network *net, Ubits32 msg_id) {

    bool success = net->recv_ubits32(&shutdown_value);

    if (!success) {
	perror("Data number mesg not received");
    }

    Back_send_shutack_msg ack_msg(shutdown_value);
   
    if ( ! ( net->send_ubits32(msg_id, TRUE) && net->send_ubits32(ack_msg.type(), TRUE) && ack_msg.encode(net) ) ) {
       fail("error sending shut ack\n");
    }
    fprintf(stderr,"Received shutdown message from Primary. Acknowledged and shutting down.\n");

    if (shutdown_value) {

       kill(getpid(),SIGTERM);
    }
    
    return TRUE;
}

#endif






