#ifndef _FRAG_H
#define _FRAG_H

// A "fragment" represents an in-memory copy of the portion
// of a segment stored in one region.

#include "lmm/finfo.h"
#include "lmm/ldformat.h"
#include "scache.h"

class Itable_Mods;

class Fragment : public CacheEntry {
  public:
    Fragment(int fid, FragRange);
    // effects	Create an in-memory fragment structure for storing the
    //		contents of the fragment named by "fid".

    Fragment(int fid, FragRange, Ldisk_Fragment* contents);
    // effects	Create an in-memory initialized fragment structure for
    //		storing the contents of the fragment named by "fid".

    virtual ~Fragment();

    virtual int		size() const;
    virtual OR_obj*	pin(int index);
    virtual void	unpin();
  protected:
    void read_contents(bool iread);
    void write_contents();
  private:
    Ldisk_Fragment*	contents;	// The contents
    FragRange		range;		// Disk range occupied by fragment

    OR_obj* find(int index);
    // effects	Return object with specified index.
    //		Return 0 if specified object is not in this fragment.
};

// Routines to manage the creation of fragments within a region.

extern Ldisk_Region* make_region(ubits32 stamp);
// effects	Create in-memory region structure with the specified stamp.

extern bool add_fragment(Ldisk_Region* region, int seg,
			 long stamp, Itable_Mods* mods);
// requires	All of "mods" belong to segment named by "seg".
// modifies	"region"
// effects	If the region has room for these objects, allocate
//		a new fragment containing these objects and return TRUE.
//		Else return false without modifying the region.

extern void delete_region(Ldisk_Region* r);
// requires	"r" was allocated by "make_region".
// effects	Delete the corresponding region.

#endif /* _FRAG_H */
