#include <iostream.h>
#include "mm_stats.h"

MM_Stats::MM_Stats() {
    reset();
}

void MM_Stats::reset() {
    iread_cache=0;          
    iread_forward=0;        
    iread_forward_mods=0;   
    iread_disk=0;           
    iread_forward_denied=0; 
    iread_forward_timedout=0; 

    iread_forward_time.reset();
    iread_disk_time.reset();
}

void MM_Stats::print() {
    cout << "IREAD STATISTICS for OR (cummulative)" << endl;
    cout << "total= " << iread << endl;          
    cout << "served from cache = " << iread_cache << endl;          
    cout << "requests forwarded to FEs with complete segments (mods not sent) = "
	 << iread_forward << endl;        
    cout << "requests forwarded to FEs with reparable segments (mods sent) = " 
	 << iread_forward_mods << endl;        
    cout << "requests denied = " << iread_forward_denied << endl;
    cout << "requests timed out = " << iread_forward_timedout << endl;
    cout << "served from disk = " << iread_disk << endl;
    cout << "Invariant: total=cache+forwarded+forwarded_mods-denied-timedout+disk"
	 << endl;
    
    cout << "Time spent waiting for forwarded requests = " 
	 << iread_forward_time.elapsed() << endl;
    cout << "Time spent waiting for disk = " 
	 << iread_disk_time.elapsed() << endl;
    
}
