// Copyright 1995 Barbara Liskov

#ifndef _PAGETABLE_H
#define _PAGETABLE_H

// This is used only for paging experiments with Thor.  

#include "common/array.h"
#include "common/page.h"
#include "or/or.h"

#include "segtable.h"

declareArray(PageTableRep, Page*)

class Page_Table {
 public:

   Page_Table(OR *or, Segment_Table *segtab);
   // effects - create a page table from the segments in "segtab"

   Page *fetch(int pagenum);
   // effects - return the corresponding page.  Return 0 if there
   //           is no such page.

 private:

 PageTableRep *rep;

};

#endif /* _PAGETABLE_H */
