#include "utils/network.h"
#include "or/mm/logrecord.h"
#include "or/mm/log.h"
#include "prim_send_message.h"
#include "config/vdefs/REPLICATION.h"

#if REPLICATION

bool Prim_send_data_msg::encode(Network* net) {

    Log_Record* log_rec;

    if (! (net->send_ubits32(noofrecords) )) {
	perror("Prim_Send_Data: number of records failed");
	return FALSE;
    }

    for (unsigned i = 0; i < noofrecords; i++ ) {
          
          if ( (log_rec = mm_log->get_next_record_tobe_marshalled()) == 0) {
	     perror("LogError: next_tobe_marshalled outof sync\n");
	     return FALSE;
          }

	  if (! (net->send_ubits32(log_rec->type() ) )) {
	    perror("Sending type number failed");
	    return FALSE;
	  }
          if ( ! log_rec->encode(net) ) {
	    perror("Data number message failed");
	    return FALSE;
          } 
    } 
    return net->flush();
}

bool Prim_send_shutdown_msg::encode(Network* net) {

    if (! (net->send_ubits32(shutdown_value) )) {
	perror("Prim_Send_shutdown: failed");
	return FALSE;
    }
    return net->flush();
}

#endif




