// Copyright 1995 Barbara Liskov

/*
\section{Reservation Information}

This abstraction tracks the reservations made one behalf of a particular
transaction.  It stores pointers to the new versions of objects modified
by the transaction, but does not take responsibility for managing the
storage occupied by the new versions.  That is left to the client(s) of
this abstraction.

XXX _We need to make this an abstract set instead of an array._
*/

#ifndef _RINFO_H
#define _RINFO_H

#include "common/oref.h"
#include "common/orefs.h"
#include "common/or_obj.h"

class Mos;
class Nos;
class Device;

// Reservation information
class Rinfo {
  public:
    Rinfo(Mos* mos, Nos* nos);
    ~Rinfo();

    long	stamp;		// Stamp when reservations were installed
    Mos*	mos;		// Modified objects
    Nos*	nos;		// New objects
    orefs	olist;		// For new objects

    int  rep_size();
    bool encode(Device*);
    bool decode(Device*);
  private:
    Rinfo();			// To prevent default constructor
    Rinfo(Rinfo const&);	// To prevent default constructor
};

#endif /* _RINFO_H */
