// Copyright 1995 Barbara Liskov

/*
\section{Reservation Table}

The reservation table keeps track of information necessary to allow
reservations without having to read the corresponding segments into
the cache.  See "rtable.cc" for more motivation behind the interface
listed in this file.

This data structure is locked using "mm->mutex" and therefore
all public methods require that the caller holds "mm->mutex".
*/

#ifndef _RTABLE_H
#define _RTABLE_H

class OR_obj;
class Rtable_Rep;

class Rtable {
  public:
    Rtable();
    ~Rtable();

    bool reserve_space(int slots);
    // modifies	this
    // effects	Obtain reservations for specified number of slots.
    //		Returns TRUE iff successful.

    bool reserve_new(int seg, int slots, Oref& result);
    // modifies	this, result.
    // effects	Obtain reservations for a new object that occupies the
    //		specified number of slots and store the reserved oref
    //		in "result".  Returns TRUE iff successful.

    void remove(int slots);
    // requires	Space reservation has been made for specified number of slots.
    // modifies	this
    // effects	Removes that reservation.

    bool initialized(int segnum);
    // effects	Return true iff info for segment has been initialized.

    void init_seg(int segnum, int index, int slots);
    // modifies	this
    // effects	If info for segment "segnum" has not been initialized,
    //		then initialize it to record that the next available
    //		index is "index", and that the segment has specified
    //		number of "slots" free.
  private:
    Rtable_Rep* rep;
};

#endif /* _RTABLE_H */
