#ifndef _PREFETCH_INFO_H
#define _PREFETCH_INFO_H

#include "common/oref.h"

// If this variable is non-zero, then the prefetching mechanism simply
// finds the objects on the subpage of the fetched object (subpage
// size is the size of the hint). The OR filters duplicates by remembering
// which objects were recently sent to the FE.
#define USE_SUBPAGE_PREFETCHING 1

class MM_Handle;
class OR_obj;
class CacheEntry;
class Itable_Mod;

struct prefetch_obj{
    Oref oref;
    OR_obj* obj_;
};

// Note: This info is used only for supage prefetching


typedef Itable_Mod *Itable_Modp;

class Prefetch_Info {
  public:
    Prefetch_Info(int no_objects);
    // effects: Creates an initialized prefetch info object

    ~Prefetch_Info();
    
    void clear(bool release_locks);
    // effects: Resets the prefetch info object so that it can be reused in
    //          the next fetch. If release_locks is TRUE, it will unpin the
    //          segment/mods associated with the segment of first

    // Rep:
    MM_Handle* first;     // Handle of the fetched object
    prefetch_obj* pref;   // The prefetched object list
    CacheEntry*	entry;	  // Cache entry pointer for the segment
    Itable_Modp*   mod;	  // Itable modification for objects in pref
    int no_mods;          // No. of mods in mod array
    int no_objects;       // No. of objects in the pref
};


#endif /* _PREFETCH_INFO_H */
