// Copyright 1995 Barbara Liskov

// \section{Format of Special OR Objects}
//
// This file describes the format of special objects stored at the
// OR.  These objects are not part of the Thor universe, but mostly
// conform to the object-format described in "common/or_obj.h" so that
// the "MM" can manipulate these objects correctly.  However, the
// class xref, and uid fields of these objects do not
// contain any meaningful value.  The "size" and "bitfield" fields are
// correct because the "MM" depends on these fields.

#ifndef _RUNTIME_H
#define _RUNTIME_H

#include "common/or_obj.h"

// \subsection{Hidden Root}
//
// This is the hidden root of the OR.  It always has a fixed oref stored
// in the OR superblock.  It contains the orefs of other special OR
// objects.

struct OR_hidden_root {
    OR_slot	header[OR_obj_headers];	// Matches "OR_obj"
    OR_slot	root;			// Thor universe root for this OR.
};

#endif /* _RUNTIME_H */
