// Copyright 1995 Barbara Liskov

/*
\section{Read-Write Lock: concurrent and fifo fair implmentation}

RW_lock_fifo implements RW_lock. It allows concurrent readers.
It is fair and grants the lock to readers and writers in the order 
they requested it. For example, if lock requests are received as follows:
     r1 r2 w1 r3 r4 w2 r5 r6
then the lock is granted as follows
     r1 r2
     w1
     r3 r4
     w2
     r5 r6
even if r3, r4, r5, and r6 were requested when r1 and r2 were held.

*/

#ifndef _RWLOCK_FIFO_H
#define _RWLOCK_FIFO_H

#include "thread.h"
#include "rwlock.h"


class RW_lock_fifo : public RW_lock {
  public:

    RW_lock_fifo();

    virtual ~RW_lock_fifo();

    virtual void read_lock();

    virtual void read_unlock();

    virtual void write_lock();

    virtual void write_unlock();

  private:

    int readers;   // num of readers
    Mutex *m;
    Mutex *m2;
    Condition *c;
};

#endif /* _RWLOCK_FIFO_H */
