// Copyright 1995 Barbara Liskov

#ifndef _OO__H
#define _OO__H

#include "common/oref.h"
#include "common/or_obj.h"

class Thor_Object {
  public:
    Thor_Object(OR_obj*);

    Oref oref();
  protected:
    OR_obj* rep;
};

// A vector of pointers
class VecOfAny : public Thor_Object {
  public:
    VecOfAny(OR_obj* o);

    int  length();
    Oref fetch(int i);
    void store(int i, Oref);
};

// Forward declaration of the types
class Connection;
class CompositePart;
class String;
class Document;
class Manual;
class Module;
class Assembly;
class ComplexAssembly;
class BaseAssembly;
class DesignObj : public Thor_Object{
 public:
 DesignObj(OR_obj* o);
 int id();
 String* otype();
 int buildDate();
 void set_buildDate(int v);
};

 
class AtomicPart : public DesignObj {
  public:
    AtomicPart(OR_obj* o);

    int  x();
    void set_x(int);

    int  y();
    void set_y(int);

    int docId();

    int numOutgoing();
    Connection* outgoingIndex(int);

    int numIncoming();
    Connection* incomingIndex(int);

    CompositePart* partOf();
};

class Connection : public Thor_Object{
 public:
  Connection(OR_obj* o);
  String* otype();
  int length();
  AtomicPart* from();
  AtomicPart* to();
};
class CompositePart : public DesignObj{
 public:
 CompositePart(OR_obj* o);
 Document* documentation();
 int numUsedPriv();
 BaseAssembly* usedPrivIndex(int i);
 int numUsedShar();
 BaseAssembly* usedSharIndex(int i);
 int numParts();
 AtomicPart* partsIndex(int i);
 AtomicPart* rootPart();
};
class Document: public Thor_Object{
 public:
  Document(OR_obj* o);
  String* title();
  int id();
  String* text();
};

class Manual:  public Thor_Object{
 public:
  Manual(OR_obj* o);
  String* title();
  int id();
  String* text();
  int textLen();
};

class Assembly: public DesignObj{
 public:
  Assembly(OR_obj* o);
  Assembly* superassembly();
  Module* module();
};

class ComplexAssembly: public Assembly{
 public:
  ComplexAssembly(OR_obj* o);
  int numAssemblies();
  Assembly* assemblyIndex(int i);
};
class BaseAssembly: public Assembly{
 public:
  BaseAssembly(OR_obj* o);
  int numComponentsPriv();
  CompositePart* componentsPrivIndex(int i);
  int numComponentsShar();
  CompositePart* componentsSharIndex(int i);
};

class Module: public DesignObj{
 public:
  Module(OR_obj* o);
  Manual* man();
  int numAssemblies();
  Assembly* assemblyIndex(int i);
  ComplexAssembly* designRoot();
};

#endif /* _OO__H */













