// Copyright 1995 Barbara Liskov

#ifndef _SERVER_H
#define _SERVER_H

// Interface for interacting with a server.

#include "common/oref.h"
#include "common/fe_num.h"
#include "common/openhashmap.h"
#include "common/tstampgen.h"

struct prefetch_hint;
struct OR_obj;
struct or_objdesc;
struct fe_message;
struct or_message;
union  OR_slot;
class  Network;
class  Ros;
class  Mos;
class  Nos;

declareOpenHashMap(ObjectMap,Oref,OR_obj*,OREF_HASH,OREF_EQUAL)

class Server {
  public:
    Server(char const* spec);
    // requires	"spec" has the form "[<machine>]:<number>".
    // effects	Creates a connection to the OR named by "spec".

    ~Server();

    Oref root();
    // effects	Fetch oref for the OR root object and returns it.
    //		Aborts if not successful.

    OR_obj* fetch_one(Oref o, prefetch_hint*);
    // effects	Fetch object named by "o" from OR and returns it.
    //		Returns 0 if fetch is denied.
    //		Aborts on system error.
    //
    //		The returned object "x" is a heap allocated array that
    //		should be destroyed by "delete [] ((OR_slot*) x)"
    //
    //		Any prefetched objects are discarded silently.

    ObjectMap* fetch(Oref o, prefetch_hint* hint);
    // effects	Fetch object named by "o" from OR.
    //		Supply "hint" for pre-fetching purposes.
    //		Return an "oref->object" mapping for all objects
    //		supplied by OR since the last fetch.
    //
    //		The returned map is heap-allocated, and so are all the
    //		pointed to objects in the map.  These objects and the
    //		map should be deleted by the client when no longer needed.

    void commit(Ros*, Mos*, Nos*);
    // effects	Commit the specified transaction.
  private:
    Network* or;		// Connection to the OR.
    fe_num*  id;		// My identifier.
    Tstamp_Generator gen;	// Tid generator

    void skip_extra_data(or_message const& msg);
    // requires	"msg" was just read from OR.
    // effects	Skip any extra message-type-dependent data that follows
    //		"msg".

    void read_objects(int num, or_objdesc*& descs, OR_slot*& slots);
    // requires	An "OR_OBJECTS" msg for "num" objects was just read from OR.
    // modifies	"descs", "slots".
    // effects	Read descriptors and data array the follows the message.
    //		"post(descs) =" heap-allocated descriptor array.
    //		"post(slots) =" heap-allocated object slot array.

    void parse_objects(int n, or_objdesc* descs, OR_slot* slots, ObjectMap* r);
    // requires	"n, descs, slots" are the valid compontents of
    //		an "OR_OBJECTS" message.
    // modifies	"r".
    // effects	For each object x sent in message, add a mapping
    //		"x -> object data" to "r".  The object data
    //		stored in the mapping is heap-allocated.
};

#endif /* _SERVER_H */
