#include <stdio.h>
#include "address.h"
#include "device.h"

const Address Address::Error_address(0,0);

bool Address::operator<(Address const& a)  const {
    if (unique != a.unique)
	return (unique < a.unique);
    return (host_id < a.host_id);
}

bool Address::operator>(Address const& a)  const {
    return (a < *this);
} 

bool Address::encode(Device* dev) const {
    return (dev->send_buffer(this, sizeof(Address), true));
}

bool Address::decode(Device* dev) {
    return (dev->recv_buffer(this, sizeof(Address)));
}

void Address::print(FILE* fp) const {
    if (!fp) fp = stderr;
    fprintf(fp, "Id = (%u, %u) ", host_id, unique);
}
