// \section{Unique Timestamp}

#include "basic.h"
#include "device.h"
#include "global_tstamp.h"

Global_tstamp::Global_tstamp() {
}

Global_tstamp::Global_tstamp(Address a, Tstamp const& localt):
    ltime(localt), addr(a) {}

Global_tstamp::Global_tstamp(Global_tstamp const& t): ltime(t.ltime),
	addr(t.addr) {}

void Global_tstamp::operator=(Global_tstamp const& t) {
    addr  = t.addr;
    ltime = t.ltime;
}

bool Global_tstamp::operator<(Global_tstamp const& t)  const{
    if (ltime != t.ltime)
	return (ltime < t.ltime);
    return (addr < t.addr);
}
    
bool Global_tstamp::operator==(Global_tstamp const& t)  const{
    return (ltime == t.ltime && addr == t.addr);
}

bool Global_tstamp::operator>(Global_tstamp const& t) const {
    if (ltime != t.ltime)
	return (ltime > t.ltime);
    return (addr > t.addr);
}

Global_tstamp Global_tstamp::operator+(Bits32 increment) const {
    return ( Global_tstamp (addr, ltime + increment));
}

Global_tstamp Global_tstamp::max (Global_tstamp& t) const {
    return( (*this < t) ? t: *this);
}

bool Global_tstamp::encode(Device* dev) const {
    return (ltime.encode(dev) && addr.encode(dev));
}

bool Global_tstamp::decode(Device* dev) {
    return (ltime.decode(dev) && addr.decode(dev));
}

void Global_tstamp::print (FILE *fp) {
    if (!fp) fp = stderr;
    fprintf(fp, "Gts: ");
    addr.print(fp);
    ltime.print(fp);
    fprintf(fp, "\n");
}
