/* \section{Common Hash Functions} */

#ifndef _HASHFUNCS_H
#define _HASHFUNCS_H

#include "utils/basic.h"
#include "utils/bits.h"

#ifdef __cplusplus
inline int hash_int(int x) {
  /*
   * Multiply by a constant and take the bottom bits of the
   * result. Always returns positive quantities.
   */

  return (int) ((((unsigned int) x) * 1737350767) & 0x7fffffff);
}
inline unsigned hash_unsigned(unsigned x) {
  /* Multiply by a constant and return lower-order word */
  return (unsigned) (x * 1737350767); 
}
#else
#define hash_int(x) ((int) ((((unsigned int) x) * 1737350767) & 0x7fffffff))
#define hash_unsigned(x) ((unsigned) (x * 1737350767L))
#endif 


#ifdef __cplusplus
extern "C" {
#endif

extern int hash_ubits64(Ubits64);
extern int hash_string(char const*);

bool comp_int(int, int);

#ifdef __cplusplus
}
#endif

#endif /* _HASHFUNCS_H */
