// This file is designed to be included multiple times and therefore
// no header guards should be placed on it.

// "Template" for generating various kinds of hash maps.
//
// See "hmap.h" for macros that should be defined before including this.

// Check that all of the macros are defined
#ifndef HMAP
#error macro HMAP not defined for hash table instantiation.
#endif
#ifndef HKEY
#error macro HKEY not defined for hash table instantiation.
#endif
#ifndef HVAL
#error macro HVAL not defined for hash table instantiation.
#endif
#ifndef HCONTROL
#error macro HCONTROL not defined for hash table instantiation.
#endif

// Do not need to use user-specified control here
#undef HCONTROL

#define HMAP_pair name2(HMAP,_pair)
#define HMAP_rep  name2(HMAP,_rep)

// Implement the underlying hash table
#define HTABLE   HMAP_rep
#define HTYPE    HMAP_pair
#define HCONTROL HMAP_pair
#include "htable_p.h"

int HMAP::contains(HKEY k) const {
    HMAP_pair p;
    p.key = k;
    return rep.contains(p);
}

int HMAP::find(HKEY k, HVAL& v) const {
    HMAP_pair p1, p2;
    p1.key = k;
    if (rep.find(p1, p2)) {
	v = p2.val;
	return 1;
    }
    return 0;
}

int HMAP::insert(HKEY k, HVAL v) {
    HMAP_pair p;
    p.key = k;
    p.val = v;
    return rep.insert(p);
}

int HMAP::remove(HKEY k) {
    HMAP_pair p;
    p.key = k;
    return rep.remove(p);
}

// Remove the controlling macros now
#undef HMAP
#undef HKEY
#undef HVAL
#undef HMAP_pair
#undef HMAP_rep
