/*
    Intentionally not protected by #ifndef's! Define IMPL_KEY and IMPL_VALUE
    immediately before including this file. It removes the mappings for IMPL_KEY
    and IMPL_VALUE, so that they behave like arguments to the file.
*/

/*
    This file instantiates the class "Map<IMPL_KEY, IMPL_VALUE>". It should
    only be included once per distinct KEY/VALUE combination.

    Note that if the key is a primitive value (e.g. int) or a pointer, you
    will want to define KEY to be something like "IntKey" or "PtrKey<T>".
    See "map.h" for more details.

    For example, a map from integers to void *:

#define IMPL_KEY IntKey
#define IMPL_VALUE void *
#include "impl_map.t"

    This implements the type "Map<IntKey, void *>". It should be done
    only once in all the C++ source files, regardless of how many source
    files mention the type "Map<IntKey, void *>".

    Also, make sure that code for Generator<IMPL_VALUE>.
    See "impl_generator.t"

*/

#include "bhash.t"
#include "buckets.t"

#define HP HashPair<IMPL_KEY, IMPL_VALUE>

#ifdef __DECCXX
#pragma define_template Map<IMPL_KEY, IMPL_VALUE>
#pragma define_template Buckets<HP>
#pragma define_template BHash<HP, Buckets<HP>, BucketsGenerator<HP> >
#pragma define_template BucketsImpl<HP>
#pragma define_template BHashGenerator<HP, Buckets<HP>, BucketsGenerator<HP> >
#pragma define_template BucketsGenerator<HP>
#pragma define_template MapGenerator<IMPL_KEY, IMPL_VALUE>
#pragma define_template KeyGenerator<IMPL_KEY, IMPL_VALUE>
#endif

#ifdef __GNUC__
template class HP;
template class Map<IMPL_KEY, IMPL_VALUE>;
template class MapGenerator<IMPL_KEY, IMPL_VALUE>;
template class KeyGenerator<IMPL_KEY, IMPL_VALUE>;
template class Buckets<HP>;
template class BucketsImpl<HP>;
template class BucketsGenerator<HP>;
template class BHash<HP, Buckets<HP>, BucketsGenerator<HP> >;
template class BHashGenerator<HP, Buckets<HP>, BucketsGenerator<HP> >;
#endif

#undef HP

#undef IMPL_KEY
#undef IMPL_VALUE
