#ifndef IMPL_PTRMAPS_T
#define IMPL_PTRMAPS_T

#include "utils/bhash.t"
#include "utils/buckets.t"

/*
    To be included by only one source file in any given program. Allows
    use of any type "PtrMap<K,V>".
*/

#define HP HashPair<PtrKey<void>, void *>

#ifdef __DECCXX
#pragma define_template Map<PtrKey<void>, void *>
#pragma define_template Buckets<HP>
#pragma define_template BHash<HP, Buckets<HP>, BucketsGenerator<HP> >
#pragma define_template BucketsImpl<HP>
#pragma define_template BHashGenerator<HP, Buckets<HP>, BucketsGenerator<HP> >
#pragma define_template BucketsGenerator<HP>
#pragma define_template MapGenerator<PtrKey<void>, void *>;
#pragma define_template KeyGenerator<PtrKey<void>, void *>;
#endif

#ifdef __GNUC__
template class PtrKey<void>;
template class HP;
template class Buckets<HP>;
template class BucketsImpl<HP>;
template class BucketsGenerator<HP>;
template class BHash<HP, Buckets<HP>, BucketsGenerator<HP> >;
template class BHashGenerator<HP, Buckets<HP>, BucketsGenerator<HP> >;
#endif

#undef HP

#undef PtrKey
#undef void
#endif
