#ifndef IMPL_PTRSETS_T
#define IMPL_PTRSETS_T
/*
   All PtrSet's share the following instantiations. This file should be
   included exactly once among all the C++ source files that make up a
   program that uses PtrSets.
*/

#define V PtrElem<void>

#ifdef __DECCXX
#pragma define_template Buckets<V>;
#pragma define_template BucketsImpl<V>;
#pragma define_template BucketsGenerator<V>;
#pragma define_template BHash<V, Buckets<V>, BucketsGenerator<V> >;
#pragma define_template BHashGenerator<V, Buckets<V>, BucketsGenerator<V> >;
#pragma define_template Buckets<V>;
#endif

#ifdef __GNUC__
template class Buckets<V>;
template class BucketsImpl<V>;
template class BucketsGenerator<V>;
template class BHash<V, Buckets<V>, BucketsGenerator<V> >;
template class BHashGenerator<V, Buckets<V>, BucketsGenerator<V> >;
#endif

#undef V
#endif /* IMPL_PTRSETS_T */
