/*********************************************************************
    Intentionally not protected by #ifndef's! Define SET_ELEM
    immediately before including this file. It removes the definition
    for SET_ELEM, so it behaves like an argument to the file.
**********************************************************************/

/*
    This file instantiates the class "Set<SET_ELEM>". It should
    only be included once per distinct SET_ELEM type.

    Note that if the key is a primitive value (e.g. int) or a pointer, you
    will want to define SET_ELEM to be something like "IntKey" or "PtrKey<T>".
    See "set.h" and "valuekey.h" for more details.

    For example, a set of integers:

#define SET_ELEM IntElem
#include "impl_set.t"

    This implements the type "Set<IntElem>". It should be done
    only once in all the C++ source files, regardless of how many source
    files mention the type.

    Also, make sure that code for Generator<SET_ELEM> is produced.
    See "impl_generator.t"

*/

#include "bhash.t"
#include "buckets.t"

#ifdef __DECCXX
#pragma define_template Set<SET_ELEM>;
#pragma define_template SetGenerator<SET_ELEM>;
#pragma define_template Buckets<SET_ELEM>;
#pragma define_template BucketsImpl<SET_ELEM>;
#pragma define_template BucketsGenerator<SET_ELEM>;
#pragma define_template BHash<SET_ELEM, Buckets<SET_ELEM>, BucketsGenerator<SET_ELEM> >;
#pragma define_template BHashGenerator<SET_ELEM, Buckets<SET_ELEM>,		      \
 				BucketsGenerator<SET_ELEM> >;
#pragma define_template Buckets<SET_ELEM>;
#endif

#ifdef __GNUC__
template class Set<SET_ELEM>;
template class SetGenerator<SET_ELEM>;
template class Buckets<SET_ELEM>;
template class BucketsImpl<SET_ELEM>;
template class BucketsGenerator<SET_ELEM>;
template class BHash<SET_ELEM, Buckets<SET_ELEM>, BucketsGenerator<SET_ELEM> >;
template class BHashGenerator<SET_ELEM, Buckets<SET_ELEM>,		      \
 				BucketsGenerator<SET_ELEM> >;
#endif

#undef SET_ELEM
