#ifndef _UTILS_LIST_H
#define _UTILS_LIST_H

class List {
  public:
    List(void *item_, List *next_) : item(item_), next(next_) {}
    ~List() { delete next; }

    void * const item;
    List * const next;

    static List *cons(void *item, List *l);
    static List *map(List *l, void *(*f)(void *item, void *env), void *env);
    static List *reverse(List *l);

    static List *one(void *item);
    static List *empty();
};

inline List* List::cons(void *item, List *l) {
    return new List(item, l);
}

inline List* List::one(void *item) {
    return new List(item, 0);
}

inline List* List::empty() {
    return 0;
}

inline List* List::map(List *l, void *(*f)(void *item, void *env), void *env) {
    if (!l) return 0;
    return List::cons(f(l->item, env), map(l->next, f, env));
}

inline List* List::reverse(List *l) {
    List *prev = 0;
    while (l) {
        prev = new List(l->item, prev);
        l = l->next;
    }
    return prev;
}

#endif /* _UTILS_LIST_H */
