#ifndef _MDEBUG_H
#define _MDEBUG_H

/* Include this file and set the MALLOC_DEBUG variable in vdefs.in to be
   true if you want to find memory leaks and other errors

   The way to use this file is:
   1. Include it in the place where you want to test new/malloc
   2. Create a $HOME/.mallocrc file (see the sample mallocrc)
   3. Run configure at top level with "-with-mdebug" option.
   4. Execute (say) "eval `malloc_dbg debug1`" to set up the debugging
   5. Set the envirnoment MALLOC_LOGFILE to the filename where you want the
      information to be dumped
   6. Read the info pages for more information

   Note: This file has to be included after stdlib.h has been included and
   also after this file has been included, there should be no definitions
   of a class that defines the new operator.

*/
#include "config/vdefs/MALLOC_DEBUG.h"

#if MALLOC_DEBUG
#ifdef __cplusplus
extern "C" {
#endif

#include <stdlib.h>
#include <malloc_dbg.h>

#ifdef __cplusplus
}
#endif

extern char* _malloc_file;
extern unsigned int _malloc_line;

#ifdef __cplusplus
/* XXX This is very very very ugly and probably buggy as well. */
#define new ((_malloc_line = __LINE__) && (_malloc_file = __FILE__) && 0) ? 0 : new

// void *operator new(size_t n);
void operator delete(void * cp);
#endif

#endif  /* of MALLOC_DEBUG */

#endif /* _MDEBUG_H */
