#ifndef _MESSAGE_H
#define _MESSAGE_H

#include "bits.h"

// This is the basic message class that contains information common to all
// messages. The send_message and recv_message inherit from this class.
// This is an immutable class

class Message {
  public:
    virtual Ubits32 type() const = 0;
    // Effects: Returns the type of the messages sent by this class.  

    // The following non-virtual method is used for debugging
    inline bool check(Ubits32 msg_type) { return type() == msg_type;}
    // effects: Returns TRUE iff the message is of the expected type
};

// The following macro is used to define a receive or send message type
// as belonging to a given type.
#define Define_message_type(m_t) \
    Ubits32 type() const {return m_t;}

#endif /* _MESSAGE_H */
