#ifndef _RANDOM_H
#define _RANDOM_H

class Random {
    // Generates random numbers.
public:
    Random();

    void seed(long seed);
    // Seed the generator. Optional but recommended.

    virtual double next();
    // Returns next random number.
};

class Composed_random: public Random {
public:
    Composed_random(double prob1, Random *random1, Random *random2);
    // With probability prob1, invoke random1, else invode random2.
    // Required 0 <= prob1 <= 1.
    virtual double next();
private:
    double prob1;
    Random *const random1;
    Random *const random2;
};

class Uniform_random: public Random {
public:
    Uniform_random(double mean, double spread);
    // Generates uniform randoms in [mean-spread/2, mean+spread/2)
    virtual double next();
private:
    double const mean, spread;
};

class Exponential_random: public Random {
public:
    Exponential_random(double d);
    // Generates dual exponential random with standard deviation d*sqrt(2).
    // f(x) = 1/(2d)*e(-|x|/d)
    virtual double next();
private:
    double const s; // standard dev
};

class Normal_random : public Random {
    // Generates normal (aka Gaussian) randoms.
public:
    Normal_random(double mean, double sd, int accuracy=6);
    // Generates normal random numbers with given mean and standard deviation.
    // Accuracy determines how many uniform random numbers will be used
    // to generate each normal random number; recommended >= 6, required > 0.

    double next();
    // Returns next random number.
private:
    Normal_random(); // disallowed
    double factor, offset; 
    int const uniforms; // accuracy
};

#endif /* _RANDOM_H */
