#include <stdlib.h>
#include "random_permuter.h"

Random_permuter::Random_permuter(unsigned n_): n(n_) {
    numbers = new unsigned[n];
    reset();
}

void Random_permuter::reset() {
    remain = n;
    for (unsigned i = 0; i < n; i++) 
	numbers[i] = i;
}

Random_permuter::~Random_permuter() {
    delete [] numbers;
}

unsigned Random_permuter::get() {
    if (remain == 0) return n;
    unsigned i = unsigned(drand48() * remain); // random in 0..remain-1
    unsigned result = numbers[i];
    numbers[i] = numbers[remain-1];
    remain--;
    return result;
}

