#ifndef _SEND_MESSAGE_H
#define _SEND_MESSAGE_H

#include "bits.h"
#include "message.h"
#include "network.h"



class Send_message: public Message {
    //
    // Overview: Each type of message has two associated classes: one class that
    //           derives from "Send_message" and another class that derives from
    //           "Recv_message". The instances of the first class are
    //           responsible for sending messages of the type, and instances
    //           of the second class are responsible for receiving messages of
    //           the type. Thus it is imperative to keep the two definitions
    //           in sync. 

  public:
    // Each subclass should implement the pure virtual methods.

    virtual bool encode(Network* net) = 0;
    // Requires: The contents of the message can be decoded by the decode
    //           function of the companion Recv_message class for the same type.
    // Effects:  Sends "this" on "net". Returns TRUE iff succeeds
    //           The network must be flushed if needed

    bool encode(Network* net, Ubits32 msg_id);
    // Requires: as in encode(net).
    // Effects:  Sends type() and msg_id on the net. Then calls encode(net).

};

inline bool Send_message::encode(Network* net, Ubits32 msg_id) {
    return net->send_ubits32(type(), TRUE) &&
	net->send_ubits32(msg_id, TRUE) &&
	encode(net);
}

#endif /* _SEND_MESSAGE_H */
