#include "stack_refs.h"


Stack_refs::Stack_refs(void *st, unsigned no, unsigned sz) : start(st),
  end((char*)st+sz*no), ref_map(no, false) {
    unsigned int mask = 1;

    // Compute shift bits
    while (mask < sz) {
      mask = mask << 1;
      shift_bits++;
    }
    th_assert(mask == sz, "Element size is not a power of 2");
}


Stack_refs::~Stack_refs() {}


void Stack_refs::compute(void **stack_botttom) { 
  Stack_refs *list[1];
  list[0] = this;
  Stack_refs::compute(list, 1, stack_botttom);
}


void Stack_refs::compute(Stack_refs **list, Uint size, void **stack_bottom) {
  register Uint i;

  // Clear ref_maps
  for (i=0; i < 1; i++) list[i]->ref_map.clear();
   
  jmp_buf env;      // variable that will hold the register values
  _setjmp(env);     // fill in register values should work in most
                    // versions of Unix.

  void **stack_now = (void**)&env;
  register void **stack_low;
  register void **stack_hi;
  if (stack_now < stack_bottom) { // for portability
    stack_low = stack_now;
    stack_hi  = stack_bottom;
  } else {
    stack_low = stack_bottom;
    stack_hi  = stack_now + sizeof(env)/sizeof(void*);
  }

  // Update the ref_maps of the various elements in list
  // by scanning the stack (register values will also be scanned
  // because they are in the stack).
  for (; stack_low < stack_hi; stack_low++) {
    register const void *stack_value = *stack_low; 
    for (i=0; i < size; i++) {
      register Stack_refs &sr = *list[i];
      register const void *start = sr.start;
      if (stack_value >= start & stack_value < sr.end) {
	// Stack_value points within region of interest
	int index = ((char*)stack_value-(char*)start) >> (int)sr.shift_bits;
	sr.ref_map.set(index);
      }
    }
  }
}
