#include <iostream.h>
#include "utils/bool_vector.h"
#include "utils/bits.h"

inline void report(bool test, char const* msg) {
    cerr << msg << ": " << (test ? "OK" : "ERROR") << endl;
}

static bool test_bool_vector_values(Bool_vector bv, bool value)
// test that all values in bool vector are "value"
{
    for (Uint i = 0; i < bv.size(); i++)
	if (bv.test(i) != value) return FALSE;
    return TRUE;
}

static void test_bool_vector_size (Uint size)
// test bool_vector of given size 
{
    cerr << endl << "size = " << size << endl;
    // constructors and assignment
    Bool_vector b1(size, FALSE);
    report(test_bool_vector_values(b1, FALSE), "initializing FALSEs");

    Bool_vector b2(size, TRUE);
    report(test_bool_vector_values(b2, TRUE), "initializing TRUEs");

    Bool_vector b3 = b2;
    report(test_bool_vector_values(b3, TRUE), "copy constructor");

    b3 = b1;
    report(test_bool_vector_values(b3, FALSE), "assignment");
    
    report(b1.size() == size, "size");
    if (size == 0) return;

    // set, reset, assign, test
    b1.set(0);
    report(b1.test(0), "set and test(0)");
    b1.reset(0);
    report(!b1.test(0), "reset and test(0)");

    b1.set(size-1);
    report(b1.test(size-1), "set and test(size-1)");
    b1.reset(size-1);
    report(!b1.test(size-1), "reset and test(size-1)");

    b1.assign(size/2, TRUE);
    report(b1.test(size/2), "assign TRUE and test(size/2)");
    b1.assign(size/2, FALSE);
    report(!b1.test(size/2), "assign FALSE and test(size/2)");
    
    // op |, &, and ~
    b3 = b1 | b2;
    report(test_bool_vector_values(b3, TRUE), "op |");
    b3 = b1 & b2;
    report(test_bool_vector_values(b3, FALSE), "op &");
    b3 = b1;
    report(test_bool_vector_values(b3, FALSE), "op ~ of TRUE");
    b3 = b2;
    report(test_bool_vector_values(b3, TRUE), "op ~ of FALSE");

    // iterator
    b1.set(0);
    b1.set(size-1);
    Bool_vector::Iter iter(&b1, TRUE);
    Uint index;
    report(iter.get(index) && index == 0, "iterator 1st get");
    if (size > 1) 
	report(iter.get(index) && index == size-1, "iterator 2nd get");
    report(!iter.get(index), "iterator 3rd get");

    b2.reset(0);
    b2.reset(size-1);
    Bool_vector::Iter iter2(&b2, FALSE);
    report(iter2.get(index) && index == 0, "iterator 1st get");
    if (size > 1) 
	report(iter2.get(index) && index == size-1, "iterator 2nd get");
    report(!iter2.get(index), "iterator 3rd get");
}

void test_bool_vector() {
    cerr << "Testing Bool_vector" << endl;
    test_bool_vector_size(0);
    test_bool_vector_size(1);
    test_bool_vector_size(31);
    test_bool_vector_size(32);
    test_bool_vector_size(33);
    test_bool_vector_size(1023);
    test_bool_vector_size(1024);
    test_bool_vector_size(1025);
    cerr << "Done Bool_vector" << endl;
}

int main() {
    test_bool_vector();
    return 0;
}
