#include <iostream.h>
#include "utils/random_permuter.h"

inline void report(bool test, char const* msg) {
    cerr << msg << ": " << (test ? "OK" : "ERROR") << endl;
}

void test_random_permuter(unsigned n) {
    cerr << "Size " << n << endl;
    Random_permuter rp(n);
    bool *got = new bool[n];
    // test 3 permutations
    for (int iters = 0; iters < 3; iters++) {
	cerr << "iter " << iters << ": ";
	for (unsigned i = 0; i < n; i++)
	    got[i] = false;
	unsigned get;
	while ((get = rp.get()) != n) {
	    if (got[get]==true) cerr << "ERROR: repeated " << get << endl;
	    got[get] = true;
	    cerr << get << " ";
	}
	cerr << endl;
	for (unsigned i = 0; i < n; i++)
	    if (got[i]==false) cerr << "ERROR: uncovered " << get << endl;
	rp.reset();
    }
    delete [] got;
}

int main() {
    cerr << "Testing Random_permuter" << endl;
    test_random_permuter(0);
    test_random_permuter(1);
    test_random_permuter(2);
    test_random_permuter(23);
    test_random_permuter(1024);
}
