#ifndef _OBJREFS_H
#define _OBJREFS_H

#include "utils/basic.h"
#include "obj_bitfield.h"

class Object_references {
    // 
    // Overview: Generate indices of all the slots with references in a Fields
    //   or in an OR_obj.
    //
  public:
    Object_references(Obj_bitfield bf, unsigned int slots);
    // effects	Create a generator that yields the slot numbers of
    //		all ref slots in an object with the specified bitfield
    //		and the specified number of data slots.

    bool get(int& x);
    // modifies	this, x
    // effects	If more reference slots are available, modify "x" to
    //		contain the index of the next reference slot and return TRUE.
    //		Else do not modify "x" and return FALSE.
  private:
    Obj_bitfield bf;		// The bitfield
    int  num;			// Number of slots
    int  index;			// Index of next field to check
    int  bf_size;               // Size of prefix bitfield.
};

inline Object_references::Object_references(Obj_bitfield b, unsigned int slots) {
  bf = b;
  num = slots;
  index = 0;
  bf_size = (OBJ_BF_ISSPECIAL(b)) ? OBJ_BF_SIZE_F(b) : num;
}

inline bool Object_references::get(int& x) {
  // If num >= 0 the generator is over the bitfield prefix.
  // Otherwise, it is iterating over an "all refs" sufix of the slots 
  // of the object.
  while (index < bf_size) {
    if (num < 0 || OBJ_BF_ISREF(bf, index)) {
      x = index++;
      return true;
    }
    index++;
  }
  // Prefix is over. If "all refs" bit is set continue iterating for the 
  // rest of the object slots, and set num to -1 to ensure that  
  // OBJ_BF_ISREF is not called.
  if (index < num && OBJ_BF_REFS(bf)) {
    bf_size = num;
    num = -1;
    x = index++;
    return true;
  }
  return false;
}

#endif /* _OBJREFS_H */
