#!/usr/local/bin/expect --

source perf.tcl

# This file contains lower level controls for the experiment

if {![string compare $G_hostname "XXXnote"]} {
    if {$use_raw} {
	set G_DB_FILENAME "/dev/rrz14h"
    }
} elseif {![string compare $G_hostname "XXXclef"]} {
    if {$use_raw} {
	# set G_DB_FILENAME "/dev/rrz14a"
	set G_DB_FILENAME "/dev/rrz3b"
    }
} else {
    if {$use_raw} {
	send_user "Error: Raw partitions on fugue/harmony can be used only\n"
	exit -1
    }
}

# Open the files to be used for the experiment
set G_cargs ""
set G_fe_fileid [open $G_fe_filename "w"]
set G_or_fileid [open $G_or_filename "w"]

set len [llength $argv]
set comm ""
set gap "            "
set gaplen [expr [string length $gap] + 1]
set count $gaplen
for {set i 0} {$i < $len} {incr i} {
    set arg "[lindex $argv $i]"
    set arglen [expr [string length $arg] + 1]
    if {$count + $arglen > 75} {
	set comm "$comm\n$gap"
	set count $gaplen
    }
    set comm "$comm $arg"
    incr count $arglen
}

send_user "Params to OO7.tcl:\n\n$comm\n\n"
# Print the configuration being used

set config_str "
$G_linestr
Configuration
$G_linestr

Params    = $comm
User      = $username, Hostname = $G_hostname (for script)
FE Output = $G_fe_filename
OR Output = $G_or_filename
Time      = [exec date]
Top       = $G_TOP, Multi trans = $G_multi_trans

Travlist  = $G_travlist
Temp      = $G_exp_temp, Hot count = $G_hot_count, Shift = $G_shifting_workload
Hotcold   = $G_hotcold_workload
OR Params : Machine = $G_or_machine, Exec = $G_or_executable  Raw = $use_raw
            Cache = $or_cachesize KB, DB File = $G_DB_FILENAME
            Args = $G_or_args

FE Params : Machine = $G_fe_machine, Exec = $G_fe_executable
            Cache = $fe_cachesize KB
            Args = $G_fe_args

Iters     = $G_iters
$G_linestr
"

send_file $G_or_fileid 1 $config_str
send_file $G_fe_fileid 1 $config_str

for {set G_iter_num 0} {$G_iter_num < $G_iters} {incr G_iter_num} {
    set G_exp_number 0
    foreach traversal $G_travlist {
	send_file $G_fe_fileid 1 "\n$G_linestr\n"
	# Run the cold traversal or hot traversal
	#	set G_machine_number [hostname_to_address $G_hostname]
	set is_hot [string compare $G_exp_temp "cold"]
	do_traversal $G_or_machine $G_fe_machine $G_or_fileid $G_fe_fileid\
	    $G_or_args $G_fe_args $G_cargs $traversal $is_hot $G_multi_trans
	incr G_exp_number
    }
}

send_user "Finishing the experiment ...\n"
set out_data "Time = [exec date]\n"
send_file $G_fe_fileid 1 $out_data
send_file $G_or_fileid 1 $out_data
send_user "Statstics files are:\n"
send_user "FE:  $G_fe_filename\n"
send_user "OR:  $G_or_filename\n"
