#include "or_obj.h"

implementArray(OR_slot_array,OR_slot)

void OR_obj::print(int fslots, FILE *fp) {
    if (!fp) fp = stderr;
    Xref xref;
    if (is_surrogate(xref)) {
	fprintf(fp, "Surr: Xref = ");
	xref.print(fp);
	fprintf(fp, "\n");
    } else {
	Oref coref = class_oref();
	char oref_str[40];
	Oref_unparse(coref, oref_str);
	fprintf(fp, "Norm: Slots = %d, C_oref = %s\n",
		fslots + OR_obj_headers, oref_str);
	OR_slot* f = fields();
	for (int i = 0; i < fslots; i++) {
	    char ostr[40];
	    Oref_unparse(f[i].get_oref(), ostr);
	    fprintf(fp, "Slot %8d = %8u (Oref = %s)\n", i, f[i].uvalue32, ostr);
	}
    }
}

OR_obj* OR_obj::create(Uint num_slots) {
    OR_slot* slots = new OR_slot[OR_obj_headers + num_slots];
    return (OR_obj *) slots;
}

