#include "orefs.h"
#include "utils/device.h"

implementArray (Orefs, Oref)

int encode_orefs_size(Orefs const* refs) {
    return sizeof(Ubits32) + (sizeof(Oref) * refs->size());
}

bool encode_orefs(Orefs const *refs, Device *dev) {
    Ubits32 num = (Ubits32) refs->size();
    return (dev->send_ubits32(num, TRUE) &&
	    dev->send_buffer(refs->as_pointer(), (num*sizeof(Oref))));
}

bool decode_orefs(Orefs *refs, Device *dev) {
    Ubits32 count;
    if (!dev->recv_ubits32(&count)) return FALSE;

    refs->clear();
    refs->_enlarge_by(count);
    return (dev->recv_buffer(refs->as_pointer(), count*sizeof(Oref)));
}


