XXX The perf.tcl file in this directory is no longer valid for osdi.tcl
#!/usr/local/bin/expect --

source perf.tcl 

set username [exec logname]

# For the dummy trials
set G_DB_FILENAME "$env(HOME)/nfs/osdi/thor/alpha/or/vsmall"
set env(THOR_SEGINFO) "$env(HOME)/nfs/osdi/thor/alpha/or/ranges.vsmall"
set G_DB_NAME "v"

# For the real database
set G_DB_FILENAME "/space2/$username/small8_100"
set env(THOR_SEGINFO) "$env(HOME)/nfs/osdi/thor/alpha/or/ranges8_100"
set G_DB_NAME "s"
set exp_or_mach "gamba"
if {$G_or_machine != $exp_or_mach && !$use_raw} {
    send_user "OR machine  must be $exp_or_mach if not using raw\n"
    exit 1
}

if {![string compare $G_or_machine "note"]} {
    if {$use_raw} {
	set G_DB_FILENAME "/dev/rrz14h"
    }
} else {
    if {$use_raw} {
	send_user "Error: Raw partition on note can be used only($G_hostname)\n"
	exit -1
    }
}

set c_args ""
set num_clients [llength $G_client_machs]

# ----------------------------------------------------------------------
# Parameters specific to experiments
# ----------------------------------------------------------------------

# set G_PARAMFILE_NAME "$env(HOME)/nfs/osdi/thor/alpha/client/C++/OO7/param1"

# Static variables
set or_args "-n $num_clients"
set fe_args "-s 14336"

# ----------------------------------------------------------------------

global G_Dyn_Preamble_data

# Number of times experiment was set up
set G_setup_num 0
set resdirnum 0
set G_resdirbase $G_resdir
set system_list {data_med data_all data_base}
# set system_list {dm da db}

while 1 {
    incr resdirnum
    foreach system $system_list {
	regsub -all "data_" $system "" sys
	set G_resdir "$G_resdirbase-$sys-$resdirnum"
	make_params $system G_params
	# Dynamic variables 
	set G_PARAMFILE_NAME "$G_resdir/$username-param"
	set mixes $G_params(mixes)
	set shared_ratios $G_params(shared)
	set logsizes $G_params(logsizes)
	set scaches $G_params(server_cache)
	set exp_or_args "$or_args $G_params(or_args)"
	set exp_fe_args "$fe_args $G_params(fe_args)"

	if {![file exists $G_resdir]} {
	    exec mkdir $G_resdir
	}
	
	# Remove all files with the name $G_resdir/username-*
	set result [catch {set filenames [glob $G_resdir/$username-*]} errorstring]
	if {!$result} {
	    foreach file $filenames {
		exec rm -f $file
	    }
	}
	
	foreach logsize $logsizes {
	    set logksize [expr $logsize * 1000]
	    set exp_or_args "$exp_or_args -l $logksize"
	    foreach scache_size $scaches {
		set exp_or_args "$exp_or_args -S $scache_size"
		foreach shared_ratio $shared_ratios {
		    foreach mix $mixes {
		    set_up_experiment $G_or_machine $G_client_machs $exp_or_args\
			$exp_fe_args $c_args G_or_id G_client_fes G_or_fileid
		    set G_new_processes 1
			set G_Dyn_Preamble_data "SYSTEM: $system, G_resdir: $G_resdir"
			make_params_file $mix $shared_ratio $G_PARAMFILE_NAME
			for {set iter 0} {$iter < $G_iters} {incr iter} {
			set G_Dyn_Preamble_data "$G_Dyn_Preamble_data ITER = $iter\n"
			    run_experiment $G_or_id $G_or_fileid $G_client_fes\
				$G_PARAMFILE_NAME $G_trans $G_warm_trans
			}
		    end_experiment
		    destroy_experiment
		    # end of foreach shared_ratio
		    }
		}
	    }
	}
    }
}
