/*
\section{Slot Datatypes}

"fe_slot" and "or_slot" are data types whose size is the same as the
size of slots at the respective locations. They must be an unsigned
integer of size 32-bits or 64-bits to allow integer operations on
them.  

*/

#ifndef _SLOT_H
#define _SLOT_H

#include "utils/bits.h"
#include "config/vdefs/SMALL_SLOTS.h"

/* Slot_bits = log2(Slot_size). Used to determine how many bits in the
   address space (of bytes) does one slot take */


#if SMALL_SLOTS
typedef Ubits32 Slot;
#define Slot_bits 2
#else
typedef Ubits64 Slot;
#define Slot_bits 3
#endif

#define Slot_size sizeof(Slot)

#endif /* _SLOT_H */
