#include "common/basic.h"
#include "utils/network.h"
#include "common/other_unix.h"
#include "common/fail.h"
#include <stdlib.h>
#include <stdio.h>

// Network error handler that prevents OR crashes.
static void print_warning(Device*, char const* msg) {
    warn(msg);
}

void main () {
    // Create socket
    int sock;
    if ((sock = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
	sysfail("socket");
    }

    // Allow address reuse
    int opt = 1;
    if (setsockopt(sock, SOL_SOCKET, SO_REUSEADDR, &opt, sizeof(opt)) < 0) {
	sysfail("setsockopt");
    }

    // Bind address
    struct sockaddr_in addr;
    addr.sin_family = AF_INET;
    addr.sin_addr.s_addr = INADDR_ANY;
    addr.sin_port = htons(4747);
    if (bind(sock, (struct sockaddr *) &addr, sizeof(addr)) < 0) {
	sysfail("bind");
    }

    // Allow connections
    if (listen(sock, 5) < 0) {
	sysfail("listen");
    }

    // Accept connections
    loop {
	struct sockaddr_in from;
	int from_size = sizeof(from);
	int fd;

	if ((fd = accept(sock, (struct sockaddr *) &from, &from_size)) < 0) {
	    syswarn("accept");
	    continue;
	}

	Network* net = new Network(fd);
	net->set_handler(print_warning);
        int maxsend = 2000000;
        int max_objects = 4;
        char *bigbuf = new char[maxsend];
        int size = 0;
        bool sendvec = FALSE;
	iovec *iov = new iovec[max_objects];

        // Do work
	loop {
	  if (net->recv_buffer(&size, sizeof(int)) && 
	      (size > 0) && 
	      (size < maxsend)) {
	    if (sendvec) {
	      fprintf(stderr, "writev\n");
	      for (int i = 0; i < max_objects; i++) {
		iov[i].iov_base = bigbuf;
		iov[i].iov_len = size / max_objects;
	      }
	      if (!(net->send_vector(iov, max_objects) && net->flush())) {
		fprintf(stderr, "Couldn't send message to client\n");
		break;
	      }
	    }
	    else {
	      fprintf(stderr, "write\n");
	      if (!(net->send_buffer(bigbuf, size) && net->flush())) {
		fprintf(stderr, "Couldn't send message to client\n");
		break;
	      }
	    }
	    sendvec = !sendvec;
	  }
	  else {
	    break;   /* client went away */
	  }
	}
      }
  }

